<?php

namespace App\Events;

use App\Models\Opportunity;
use App\Models\PipelineStage;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class OpportunityStageChanged
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public function __construct(
        public Opportunity $opportunity,
        public ?PipelineStage $oldStage,
        public PipelineStage $newStage
    ) {}
}
