<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class StoreWorkflowRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'trigger' => 'required|array',
            'trigger.type' => 'required|string',
            'trigger.conditions' => 'nullable|array',
            'steps' => 'required|array|min:1',
            'steps.*.type' => 'required|in:send_email,send_sms,send_whatsapp,add_tag,remove_tag,create_task,wait,if_else,webhook,update_field',
            'steps.*.config' => 'required|array',
            'steps.*.delay' => 'nullable|array',
            'is_active' => 'nullable|boolean',
        ];
    }
}
