<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreEmployeeRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'user_id' => 'required|exists:users,id|unique:employees,user_id',
            'employee_id' => 'nullable|string|max:50|unique:employees,employee_id',
            'department_id' => 'nullable|exists:departments,id',
            'manager_id' => 'nullable|exists:employees,id',
            'hire_date' => 'required|date',
            'job_title' => 'required|string|max:255',
            'employment_type' => 'required|in:full_time,part_time,contract,intern',
            'work_location' => 'nullable|string|max:255',
            'nationality' => 'nullable|string|size:2',
            'date_of_birth' => 'nullable|date|before:today',
            'gender' => 'nullable|in:male,female,other',
            'marital_status' => 'nullable|in:single,married,divorced,widowed',
            'cpr_number' => 'nullable|string|max:20',
            'passport_number' => 'nullable|string|max:20',
            'passport_expiry' => 'nullable|date',
            'visa_status' => 'nullable|string|max:50',
            'visa_expiry' => 'nullable|date',
            'emergency_contact_name' => 'nullable|string|max:255',
            'emergency_contact_phone' => 'nullable|string|max:50',
            'emergency_contact_relation' => 'nullable|string|max:50',
            'bank_name' => 'nullable|string|max:255',
            'bank_account_number' => 'nullable|string|max:50',
            'bank_iban' => 'nullable|string|max:50',
            'basic_salary' => 'nullable|numeric|min:0',
            'housing_allowance' => 'nullable|numeric|min:0',
            'transport_allowance' => 'nullable|numeric|min:0',
            'other_allowances' => 'nullable|numeric|min:0',
        ];
    }
}
