<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreExpenseRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'expense_date' => 'required|date',
            'description' => 'required|string|max:500',
            'amount' => 'required|numeric|min:0.001',
            'currency' => 'nullable|string|size:3',
            'category' => 'required|string|max:50',
            'account_id' => 'nullable|exists:chart_of_accounts,id',
            'vendor_id' => 'nullable|exists:vendors,id',
            'project_id' => 'nullable|exists:projects,id',
            'payment_method' => 'nullable|in:cash,credit_card,bank_transfer,petty_cash',
            'reference' => 'nullable|string|max:100',
            'is_billable' => 'boolean',
            'is_reimbursable' => 'boolean',
            'notes' => 'nullable|string|max:1000',
            'receipt' => 'nullable|file|max:5120|mimes:jpg,jpeg,png,pdf',
        ];
    }
}
