<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreLeaveRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'leave_type_id' => 'required|exists:leave_types,id',
            'start_date' => 'required|date|after_or_equal:today',
            'end_date' => 'required|date|after_or_equal:start_date',
            'start_half_day' => 'boolean',
            'end_half_day' => 'boolean',
            'reason' => 'nullable|string|max:500',
            'attachment' => 'nullable|file|max:5120',
        ];
    }

    public function messages(): array
    {
        return [
            'start_date.after_or_equal' => 'Leave cannot be requested for past dates.',
            'end_date.after_or_equal' => 'End date must be on or after start date.',
        ];
    }
}
