<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreProjectRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:2000',
            'start_date' => 'nullable|date',
            'due_date' => 'nullable|date|after_or_equal:start_date',
            'status' => 'nullable|in:active,on_hold,completed,archived',
            'budget' => 'nullable|numeric|min:0',
            'budget_type' => 'nullable|in:fixed,hourly',
            'hourly_rate' => 'nullable|numeric|min:0',
            'is_billable' => 'boolean',
            'client_id' => 'nullable|exists:contacts,id',
        ];
    }
}
