<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreTimeEntryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'project_id' => 'required|exists:projects,id',
            'task_id' => 'nullable|exists:tasks,id',
            'date' => 'required|date|before_or_equal:today',
            'hours' => 'required|numeric|min:0.25|max:24',
            'description' => 'nullable|string|max:500',
            'is_billable' => 'boolean',
        ];
    }

    public function messages(): array
    {
        return [
            'hours.min' => 'Minimum time entry is 15 minutes (0.25 hours).',
            'hours.max' => 'Maximum time entry is 24 hours per day.',
        ];
    }
}
