<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateBillRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->tenant_id === $this->route('bill')->tenant_id;
    }

    public function rules(): array
    {
        return [
            'vendor_id' => 'sometimes|exists:vendors,id',
            'bill_number' => 'sometimes|string|max:50',
            'bill_date' => 'sometimes|date',
            'due_date' => 'sometimes|date|after_or_equal:bill_date',
            'items' => 'sometimes|array|min:1',
            'items.*.description' => 'required_with:items|string|max:255',
            'items.*.quantity' => 'required_with:items|numeric|min:0.01',
            'items.*.unit_price' => 'required_with:items|numeric|min:0',
            'items.*.account_id' => 'nullable|exists:chart_of_accounts,id',
            'notes' => 'nullable|string|max:1000',
        ];
    }
}
