<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateContactRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->tenant_id === $this->route('contact')->tenant_id;
    }

    public function rules(): array
    {
        return [
            'first_name' => 'sometimes|string|max:100',
            'last_name' => 'sometimes|string|max:100',
            'email' => [
                'sometimes',
                'email',
                'max:255',
                Rule::unique('contacts')->where(fn($q) => $q->where('tenant_id', $this->user()->tenant_id))
                    ->ignore($this->route('contact')->id),
            ],
            'phone' => 'nullable|string|max:50',
            'mobile' => 'nullable|string|max:50',
            'company_name' => 'nullable|string|max:255',
            'job_title' => 'nullable|string|max:100',
            'website' => 'nullable|url|max:255',
            'address_line_1' => 'nullable|string|max:255',
            'address_line_2' => 'nullable|string|max:255',
            'city' => 'nullable|string|max:100',
            'state' => 'nullable|string|max:100',
            'postal_code' => 'nullable|string|max:20',
            'country' => 'nullable|string|size:2',
            'lead_status' => 'nullable|in:new,lead,qualified,customer,lost',
            'source' => 'nullable|string|max:50',
            'owner_id' => 'nullable|exists:users,id',
            'notes' => 'nullable|string',
        ];
    }
}
