<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateVendorRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->tenant_id === $this->route('vendor')->tenant_id;
    }

    public function rules(): array
    {
        return [
            'name' => 'sometimes|string|max:255',
            'contact_name' => 'nullable|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'nullable|string|max:50',
            'website' => 'nullable|url|max:255',
            'address' => 'nullable|string|max:500',
            'city' => 'nullable|string|max:100',
            'country' => 'nullable|string|size:2',
            'tax_number' => 'nullable|string|max:50',
            'payment_terms' => 'nullable|in:net_15,net_30,net_45,net_60,due_on_receipt',
            'currency' => 'nullable|string|size:3',
            'notes' => 'nullable|string|max:1000',
        ];
    }
}
