<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DepartmentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'description' => $this->description,
            'manager_id' => $this->manager_id,
            'manager' => $this->whenLoaded('manager'),
            'parent_id' => $this->parent_id,
            'employees_count' => $this->whenCounted('employees'),
            'children' => DepartmentResource::collection($this->whenLoaded('children')),
            'created_at' => $this->created_at->toIso8601String(),
        ];
    }
}
