<?php

namespace App\Jobs;

use App\Models\Tenant;
use App\Services\ReportService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;

class GenerateMonthlyReport implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        protected Tenant $tenant,
        protected int $year,
        protected int $month
    ) {}

    public function handle(ReportService $reportService): void
    {
        $startDate = "{$this->year}-{$this->month}-01";
        $endDate = date('Y-m-t', strtotime($startDate));

        $report = [
            'tenant' => $this->tenant->name,
            'period' => "{$this->year}-{$this->month}",
            'revenue' => $reportService->getRevenueForPeriod($this->tenant->id, $startDate, $endDate),
            'expenses' => $reportService->getExpensesForPeriod($this->tenant->id, $startDate, $endDate),
            'new_contacts' => $reportService->getNewContactsForPeriod($this->tenant->id, $startDate, $endDate),
            'opportunities_won' => $reportService->getWonOpportunitiesForPeriod($this->tenant->id, $startDate, $endDate),
            'tasks_completed' => $reportService->getCompletedTasksForPeriod($this->tenant->id, $startDate, $endDate),
        ];

        $filename = "reports/{$this->tenant->id}/monthly-{$this->year}-{$this->month}.json";
        Storage::put($filename, json_encode($report, JSON_PRETTY_PRINT));
    }
}
