<?php

namespace App\Jobs;

use App\Models\PayrollItem;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;

class GeneratePayslipPdf implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(public PayrollItem $payrollItem) {}

    public function handle(): void
    {
        $item = $this->payrollItem->load(['employee.user', 'employee.department', 'payrollRun']);

        $pdf = Pdf::loadView('pdf.payslip', ['item' => $item]);
        
        $filename = "payslips/{$item->tenant_id}/{$item->payrollRun->id}/{$item->employee->employee_id}.pdf";
        
        Storage::put($filename, $pdf->output());

        $this->payrollItem->update(['pdf_path' => $filename]);
    }
}
