<?php

namespace App\Jobs;

use App\Models\Tenant;
use App\Services\ImportService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ImportContacts implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $timeout = 1800;

    public function __construct(
        public int $tenantId,
        public string $filePath,
        public array $mapping,
        public int $userId
    ) {}

    public function handle(ImportService $importService): void
    {
        $importService->importContacts(
            $this->tenantId,
            $this->filePath,
            $this->mapping,
            $this->userId
        );
    }
}
