<?php

namespace App\Jobs;

use App\Events\InvoiceOverdue;
use App\Models\Invoice;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessInvoiceOverdue implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(): void
    {
        Invoice::query()
            ->whereIn('status', ['sent', 'partial'])
            ->where('due_date', '<', now())
            ->where(function ($query) {
                $query->whereNull('last_reminder_sent_at')
                    ->orWhere('last_reminder_sent_at', '<', now()->subDays(7));
            })
            ->chunk(100, function ($invoices) {
                foreach ($invoices as $invoice) {
                    $invoice->update([
                        'status' => 'overdue',
                        'last_reminder_sent_at' => now(),
                    ]);

                    event(new InvoiceOverdue($invoice));
                }
            });
    }
}
