<?php

namespace App\Jobs;

use App\Events\InvoiceOverdue;
use App\Models\Invoice;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendInvoiceReminders implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(): void
    {
        Invoice::where('status', 'sent')
            ->where('due_date', '<', now())
            ->whereColumn('amount_paid', '<', 'total')
            ->each(fn($invoice) => event(new InvoiceOverdue($invoice)));
    }
}
