<?php

namespace App\Jobs;

use App\Models\PayrollRun;
use App\Notifications\PayslipNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendPayrollNotifications implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(protected PayrollRun $payrollRun) {}

    public function handle(): void
    {
        foreach ($this->payrollRun->items as $item) {
            $employee = $item->employee;
            
            if ($employee->user) {
                $employee->user->notify(new PayslipNotification($item));
            }
        }

        $this->payrollRun->update(['notifications_sent_at' => now()]);
    }
}
