<?php

namespace App\Jobs;

use App\Events\TaskDueSoon;
use App\Models\Task;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendTaskReminders implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(): void
    {
        // Tasks due today
        Task::whereDate('due_date', now())
            ->whereHas('status', fn($q) => $q->where('is_completed', false))
            ->each(fn($task) => event(new TaskDueSoon($task, 0)));

        // Tasks due tomorrow
        Task::whereDate('due_date', now()->addDay())
            ->whereHas('status', fn($q) => $q->where('is_completed', false))
            ->each(fn($task) => event(new TaskDueSoon($task, 1)));

        // Tasks due in 3 days
        Task::whereDate('due_date', now()->addDays(3))
            ->whereHas('status', fn($q) => $q->where('is_completed', false))
            ->each(fn($task) => event(new TaskDueSoon($task, 3)));
    }
}
