<?php

namespace App\Jobs;

use App\Models\BankAccount;
use App\Services\PlaidService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SyncBankTransactions implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(public BankAccount $bankAccount) {}

    public function handle(PlaidService $plaidService): void
    {
        if (!$this->bankAccount->isConnectedToPlaid()) {
            return;
        }

        $plaidService->syncTransactions($this->bankAccount);
        $this->bankAccount->update(['last_synced_at' => now()]);
    }
}
