<?php

namespace App\Listeners;

use App\Events\BillCreated;
use App\Models\ChartOfAccount;
use App\Models\JournalEntry;
use App\Models\JournalEntryLine;
use Illuminate\Support\Facades\DB;

class CreateJournalEntryForBill
{
    public function handle(BillCreated $event): void
    {
        $bill = $event->bill;
        
        DB::transaction(function () use ($bill) {
            $journalEntry = JournalEntry::create([
                'tenant_id' => $bill->tenant_id,
                'date' => $bill->bill_date,
                'reference' => $bill->bill_number,
                'description' => "Bill from {$bill->vendor->name}",
                'source_type' => 'bill',
                'source_id' => $bill->id,
            ]);

            // Debit expense accounts
            foreach ($bill->items as $item) {
                if ($item->account_id) {
                    JournalEntryLine::create([
                        'journal_entry_id' => $journalEntry->id,
                        'account_id' => $item->account_id,
                        'debit' => $item->total,
                        'credit' => 0,
                    ]);
                }
            }

            // Credit accounts payable
            $apAccount = ChartOfAccount::where('tenant_id', $bill->tenant_id)
                ->where('code', '2000')
                ->first();

            if ($apAccount) {
                JournalEntryLine::create([
                    'journal_entry_id' => $journalEntry->id,
                    'account_id' => $apAccount->id,
                    'debit' => 0,
                    'credit' => $bill->total,
                ]);
            }
        });
    }
}
