<?php

namespace App\Listeners;

use App\Events\FormSubmitted;
use App\Services\WorkflowService;
use Illuminate\Contracts\Queue\ShouldQueue;

class HandleFormSubmission implements ShouldQueue
{
    public function __construct(protected WorkflowService $workflowService) {}

    public function handle(FormSubmitted $event): void
    {
        $submission = $event->submission;
        $contact = $submission->createOrUpdateContact();

        if ($contact && $submission->form->workflow_id) {
            $this->workflowService->triggerForContact($contact, 'form_submitted', [
                'form_id' => $submission->form_id,
                'submission_id' => $submission->id,
            ]);
        }
    }
}
