<?php

namespace App\Listeners;

use App\Events\InvoiceCreated;
use App\Notifications\InvoiceCreatedNotification;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendInvoiceCreatedNotification implements ShouldQueue
{
    public function handle(InvoiceCreated $event): void
    {
        $invoice = $event->invoice;
        $contact = $invoice->contact;

        if ($contact && $contact->email) {
            $contact->notify(new InvoiceCreatedNotification($invoice));
        }
    }
}
