<?php

namespace App\Listeners;

use App\Events\LeaveRequestApproved;
use App\Notifications\LeaveApprovedNotification;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendLeaveApprovedNotification implements ShouldQueue
{
    public function handle(LeaveRequestApproved $event): void
    {
        $event->leaveRequest->employee->user?->notify(
            new LeaveApprovedNotification($event->leaveRequest)
        );
    }
}
