<?php

namespace App\Listeners;

use App\Events\LeaveRequestSubmitted;
use App\Notifications\LeaveRequestSubmittedNotification;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendLeaveRequestNotification implements ShouldQueue
{
    public function handle(LeaveRequestSubmitted $event): void
    {
        $manager = $event->leaveRequest->employee->manager;
        if ($manager) {
            $manager->notify(new LeaveRequestSubmittedNotification($event->leaveRequest));
        }
    }
}
