<?php

namespace App\Listeners;

use App\Events\ContactCreated;
use App\Services\WorkflowService;

class TriggerContactWorkflows
{
    public function __construct(protected WorkflowService $workflowService) {}

    public function handle(ContactCreated $event): void
    {
        $this->workflowService->triggerForContact($event->contact, 'contact_created');
    }
}
