<?php

namespace App\Listeners;

use App\Events\TaskCompleted;

class UpdateProjectProgress
{
    public function handle(TaskCompleted $event): void
    {
        $task = $event->task;
        $project = $task->project;

        if ($project) {
            $totalTasks = $project->tasks()->count();
            $completedTasks = $project->tasks()->whereNotNull('completed_at')->count();
            
            $project->update([
                'progress' => $totalTasks > 0 ? round(($completedTasks / $totalTasks) * 100, 1) : 0,
            ]);
        }
    }
}
