<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Traits\BelongsToTenant;

class Employee extends BaseModel
{
    use SoftDeletes, BelongsToTenant;

    protected $casts = [
        'hire_date' => 'date',
        'termination_date' => 'date',
        'probation_end_date' => 'date',
        'passport_expiry' => 'date',
        'visa_expiry' => 'date',
        'work_permit_expiry' => 'date',
        'salary_amount' => 'decimal:2',
        'benefits' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function manager(): BelongsTo
    {
        return $this->belongsTo(User::class, 'manager_id');
    }

    public function department(): BelongsTo
    {
        return $this->belongsTo(Team::class, 'department_id');
    }

    public function payrollItems(): HasMany
    {
        return $this->hasMany(PayrollItem::class);
    }

    public function leaveRequests(): HasMany
    {
        return $this->hasMany(LeaveRequest::class);
    }

    public function attendance(): HasMany
    {
        return $this->hasMany(Attendance::class);
    }

    public function loans(): HasMany
    {
        return $this->hasMany(EmployeeLoan::class);
    }

    public function isActive(): bool
    {
        return $this->status === 'active';
    }
}
