<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;

class LeaveType extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tenant_id', 'name', 'code', 'default_days', 'is_paid',
        'requires_approval', 'max_consecutive_days', 'color',
    ];

    protected $casts = [
        'default_days' => 'decimal:1',
        'is_paid' => 'boolean',
        'requires_approval' => 'boolean',
    ];

    public function leaveRequests(): HasMany
    {
        return $this->hasMany(LeaveRequest::class);
    }

    public function balances(): HasMany
    {
        return $this->hasMany(LeaveBalance::class);
    }
}
