<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProjectMember extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'project_id',
        'user_id',
        'role',
        'hourly_rate',
        'joined_at',
    ];

    protected $casts = [
        'hourly_rate' => 'decimal:2',
        'joined_at' => 'datetime',
    ];

    const ROLE_VIEWER = 'viewer';
    const ROLE_MEMBER = 'member';
    const ROLE_MANAGER = 'manager';
    const ROLE_ADMIN = 'admin';

    protected static function booted(): void
    {
        static::creating(function ($member) {
            if (empty($member->joined_at)) {
                $member->joined_at = now();
            }
        });
    }

    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function canManage(): bool
    {
        return in_array($this->role, [self::ROLE_MANAGER, self::ROLE_ADMIN]);
    }

    public function canEdit(): bool
    {
        return in_array($this->role, [self::ROLE_MEMBER, self::ROLE_MANAGER, self::ROLE_ADMIN]);
    }

    public function canView(): bool
    {
        return true; // All roles can view
    }
}
