<?php

namespace App\Notifications;

use App\Models\LeaveRequest;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LeaveApprovedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public LeaveRequest $leaveRequest) {}

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Leave Request Approved')
            ->line('Your leave request has been approved.')
            ->line('Type: ' . $this->leaveRequest->leaveType->name)
            ->line('From: ' . $this->leaveRequest->start_date->format('M d, Y'))
            ->line('To: ' . $this->leaveRequest->end_date->format('M d, Y'))
            ->action('View Details', url('/leave-requests/' . $this->leaveRequest->id));
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'leave_approved',
            'leave_request_id' => $this->leaveRequest->id,
        ];
    }
}
