<?php

namespace App\Notifications;

use App\Models\TaskComment;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TaskCommentNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(protected TaskComment $comment) {}

    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        $task = $this->comment->task;
        $commenter = $this->comment->user;
        
        return (new MailMessage)
            ->subject("New comment on: {$task->title}")
            ->line("{$commenter->first_name} commented on a task you're involved with:")
            ->line("\"{$this->comment->content}\"")
            ->action('View Task', url("/tasks/{$task->id}"));
    }

    public function toArray(object $notifiable): array
    {
        return [
            'task_id' => $this->comment->task_id,
            'task_title' => $this->comment->task->title,
            'comment_id' => $this->comment->id,
            'commenter_name' => $this->comment->user->full_name,
            'content' => $this->comment->content,
        ];
    }
}
