<?php

namespace App\Policies;

use App\Models\BankAccount;
use App\Models\User;

class BankAccountPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->hasPermissionTo('banking.view');
    }

    public function view(User $user, BankAccount $account): bool
    {
        return $user->tenant_id === $account->tenant_id;
    }

    public function create(User $user): bool
    {
        return $user->hasPermissionTo('banking.create');
    }

    public function update(User $user, BankAccount $account): bool
    {
        return $user->tenant_id === $account->tenant_id;
    }

    public function delete(User $user, BankAccount $account): bool
    {
        return $user->tenant_id === $account->tenant_id && $user->hasPermissionTo('banking.delete');
    }
}
