<?php

namespace App\Policies;

use App\Models\Project;
use App\Models\User;

class ProjectPolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, Project $project): bool
    {
        if ($user->tenant_id !== $project->tenant_id) {
            return false;
        }

        if ($project->visibility === 'public') {
            return true;
        }

        return $project->members()->where('user_id', $user->id)->exists();
    }

    public function create(User $user): bool
    {
        return true;
    }

    public function update(User $user, Project $project): bool
    {
        if ($user->tenant_id !== $project->tenant_id) {
            return false;
        }

        $member = $project->members()->where('user_id', $user->id)->first();
        return $member && in_array($member->role, ['manager', 'admin']);
    }

    public function delete(User $user, Project $project): bool
    {
        if ($user->tenant_id !== $project->tenant_id) {
            return false;
        }

        $member = $project->members()->where('user_id', $user->id)->first();
        return $member && $member->role === 'admin';
    }

    public function manageMember(User $user, Project $project): bool
    {
        return $this->update($user, $project);
    }
}
