<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        \App\Events\InvoiceCreated::class => [
            \App\Listeners\SendInvoiceCreatedNotification::class,
        ],
        \App\Events\InvoicePaid::class => [
            \App\Listeners\SendInvoicePaidNotification::class,
        ],
        \App\Events\ContactCreated::class => [
            \App\Listeners\HandleContactCreated::class,
        ],
        \App\Events\OpportunityStageChanged::class => [
            \App\Listeners\HandleOpportunityStageChanged::class,
        ],
        \App\Events\TaskAssigned::class => [
            \App\Listeners\SendTaskAssignedNotification::class,
        ],
        \App\Events\TaskDueSoon::class => [
            \App\Listeners\SendTaskDueNotification::class,
        ],
        \App\Events\LeaveRequestSubmitted::class => [
            \App\Listeners\SendLeaveRequestNotification::class,
        ],
        \App\Events\LeaveRequestApproved::class => [
            \App\Listeners\SendLeaveApprovedNotification::class,
        ],
        \App\Events\FormSubmitted::class => [
            \App\Listeners\HandleFormSubmission::class,
        ],
        \App\Events\CampaignSent::class => [
            \App\Listeners\UpdateCampaignStats::class,
        ],
    ];
}
