<?php

namespace App\Services;

use App\Models\Bill;
use App\Models\Vendor;

class VendorService
{
    public function create(int $tenantId, array $data): Vendor
    {
        return Vendor::create([
            'tenant_id' => $tenantId,
            'name' => $data['name'],
            'email' => $data['email'] ?? null,
            'phone' => $data['phone'] ?? null,
            'address' => $data['address'] ?? null,
            'city' => $data['city'] ?? null,
            'country' => $data['country'] ?? 'BH',
            'tax_number' => $data['tax_number'] ?? null,
            'payment_terms' => $data['payment_terms'] ?? 'net_30',
            'currency' => $data['currency'] ?? 'BHD',
            'notes' => $data['notes'] ?? null,
        ]);
    }

    public function getOutstandingBalance(Vendor $vendor): float
    {
        return Bill::where('vendor_id', $vendor->id)
            ->whereIn('status', ['received', 'partial'])
            ->selectRaw('SUM(total - amount_paid) as outstanding')
            ->value('outstanding') ?? 0;
    }

    public function getBillsSummary(Vendor $vendor): array
    {
        return [
            'total_bills' => $vendor->bills()->count(),
            'total_amount' => $vendor->bills()->sum('total'),
            'total_paid' => $vendor->bills()->sum('amount_paid'),
            'outstanding' => $this->getOutstandingBalance($vendor),
            'overdue_count' => $vendor->bills()
                ->whereIn('status', ['received', 'partial'])
                ->where('due_date', '<', now())
                ->count(),
        ];
    }
}
