<?php

namespace Database\Factories;

use App\Models\BankTransaction;
use Illuminate\Database\Eloquent\Factories\Factory;

class BankTransactionFactory extends Factory
{
    protected $model = BankTransaction::class;

    public function definition(): array
    {
        $type = $this->faker->randomElement(['credit', 'debit']);
        
        return [
            'external_id' => $this->faker->uuid(),
            'transaction_date' => $this->faker->dateTimeBetween('-30 days', 'now'),
            'description' => $this->faker->sentence(4),
            'payee' => $this->faker->company(),
            'amount' => $this->faker->randomFloat(3, 10, 5000),
            'type' => $type,
            'currency' => 'BHD',
            'category' => $this->faker->randomElement(['office', 'utilities', 'travel', 'supplies']),
            'status' => $this->faker->randomElement(['pending', 'matched', 'reconciled']),
        ];
    }
}
