<?php

namespace Database\Factories;

use App\Models\EmployeeSalary;
use Illuminate\Database\Eloquent\Factories\Factory;

class EmployeeSalaryFactory extends Factory
{
    protected $model = EmployeeSalary::class;

    public function definition(): array
    {
        $basic = $this->faker->randomFloat(3, 500, 5000);

        return [
            'effective_date' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'basic_salary' => $basic,
            'housing_allowance' => $basic * 0.25,
            'transport_allowance' => 50.000,
            'other_allowances' => 0,
            'currency' => 'BHD',
        ];
    }
}
