<?php

namespace Database\Factories;

use App\Models\LeaveBalance;
use Illuminate\Database\Eloquent\Factories\Factory;

class LeaveBalanceFactory extends Factory
{
    protected $model = LeaveBalance::class;

    public function definition(): array
    {
        $entitled = $this->faker->randomElement([14, 21, 30]);
        $used = $this->faker->numberBetween(0, $entitled);

        return [
            'year' => now()->year,
            'entitled' => $entitled,
            'used' => $used,
            'carried_forward' => 0,
        ];
    }
}
