<?php

namespace Database\Factories;

use App\Models\Tenant;
use Illuminate\Database\Eloquent\Factories\Factory;

class SegmentFactory extends Factory
{
    public function definition(): array
    {
        return [
            'tenant_id' => Tenant::factory(),
            'name' => $this->faker->words(2, true) . ' Segment',
            'description' => $this->faker->sentence(),
            'is_dynamic' => $this->faker->boolean(),
            'conditions' => [],
        ];
    }

    public function dynamic(): static
    {
        return $this->state(fn() => [
            'is_dynamic' => true,
            'conditions' => [
                ['field' => 'country', 'operator' => 'equals', 'value' => 'BH'],
            ],
        ]);
    }
}
