<?php

namespace Database\Factories;

use App\Models\Tenant;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class TenantFactory extends Factory
{
    protected $model = Tenant::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->company(),
            'slug' => Str::slug($this->faker->company()) . '-' . Str::random(4),
            'email' => $this->faker->companyEmail(),
            'phone' => $this->faker->phoneNumber(),
            'address' => $this->faker->streetAddress(),
            'city' => $this->faker->city(),
            'country' => 'BH',
            'currency' => 'BHD',
            'timezone' => 'Asia/Bahrain',
            'settings' => [
                'invoice_prefix' => 'INV-',
                'tax_rate' => 10,
            ],
            'is_active' => true,
        ];
    }
}
