<?php

namespace Database\Seeders;

use App\Models\Currency;
use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    public function run(): void
    {
        $currencies = [
            ['code' => 'BHD', 'name' => 'Bahraini Dinar', 'symbol' => 'BD', 'decimal_places' => 3, 'exchange_rate' => 1],
            ['code' => 'USD', 'name' => 'US Dollar', 'symbol' => '$', 'decimal_places' => 2, 'exchange_rate' => 2.6525],
            ['code' => 'EUR', 'name' => 'Euro', 'symbol' => '€', 'decimal_places' => 2, 'exchange_rate' => 2.8850],
            ['code' => 'GBP', 'name' => 'British Pound', 'symbol' => '£', 'decimal_places' => 2, 'exchange_rate' => 3.3650],
            ['code' => 'SAR', 'name' => 'Saudi Riyal', 'symbol' => 'SR', 'decimal_places' => 2, 'exchange_rate' => 0.7073],
            ['code' => 'AED', 'name' => 'UAE Dirham', 'symbol' => 'AED', 'decimal_places' => 2, 'exchange_rate' => 0.7223],
            ['code' => 'KWD', 'name' => 'Kuwaiti Dinar', 'symbol' => 'KD', 'decimal_places' => 3, 'exchange_rate' => 1.1580],
            ['code' => 'QAR', 'name' => 'Qatari Riyal', 'symbol' => 'QR', 'decimal_places' => 2, 'exchange_rate' => 0.7290],
            ['code' => 'OMR', 'name' => 'Omani Rial', 'symbol' => 'OMR', 'decimal_places' => 3, 'exchange_rate' => 0.9783],
            ['code' => 'INR', 'name' => 'Indian Rupee', 'symbol' => '₹', 'decimal_places' => 2, 'exchange_rate' => 0.0318],
        ];

        foreach ($currencies as $currency) {
            Currency::updateOrCreate(
                ['code' => $currency['code'], 'tenant_id' => null],
                array_merge($currency, [
                    'is_active' => true,
                    'is_default' => $currency['code'] === 'BHD',
                    'symbol_position' => 'before',
                    'thousands_separator' => ',',
                    'decimal_separator' => '.',
                ])
            );
        }
    }
}
