<?php

namespace Database\Seeders;

use App\Models\LeaveType;
use Illuminate\Database\Seeder;

class LeaveTypeSeeder extends Seeder
{
    public function run(): void
    {
        $leaveTypes = [
            ['name' => 'Annual Leave', 'code' => 'AL', 'days_per_year' => 30, 'is_paid' => true, 'requires_approval' => true, 'color' => '#4CAF50'],
            ['name' => 'Sick Leave', 'code' => 'SL', 'days_per_year' => 15, 'is_paid' => true, 'requires_approval' => true, 'requires_document' => true, 'color' => '#F44336'],
            ['name' => 'Maternity Leave', 'code' => 'ML', 'days_per_year' => 60, 'is_paid' => true, 'requires_approval' => true, 'gender' => 'female', 'color' => '#E91E63'],
            ['name' => 'Paternity Leave', 'code' => 'PL', 'days_per_year' => 3, 'is_paid' => true, 'requires_approval' => true, 'gender' => 'male', 'color' => '#2196F3'],
            ['name' => 'Hajj Leave', 'code' => 'HL', 'days_per_year' => 14, 'is_paid' => true, 'requires_approval' => true, 'max_times' => 1, 'color' => '#9C27B0'],
            ['name' => 'Unpaid Leave', 'code' => 'UL', 'days_per_year' => 30, 'is_paid' => false, 'requires_approval' => true, 'color' => '#607D8B'],
            ['name' => 'Bereavement Leave', 'code' => 'BL', 'days_per_year' => 3, 'is_paid' => true, 'requires_approval' => true, 'color' => '#795548'],
            ['name' => 'Marriage Leave', 'code' => 'MRL', 'days_per_year' => 3, 'is_paid' => true, 'requires_approval' => true, 'max_times' => 1, 'color' => '#FF9800'],
        ];

        foreach ($leaveTypes as $type) {
            LeaveType::updateOrCreate(
                ['code' => $type['code'], 'tenant_id' => null],
                array_merge($type, ['is_active' => true])
            );
        }
    }
}
