<?php

namespace Database\Seeders;

use App\Models\Pipeline;
use App\Models\PipelineStage;
use App\Models\Tenant;
use Illuminate\Database\Seeder;

class PipelineSeeder extends Seeder
{
    public function run(): void
    {
        $tenant = Tenant::first();
        
        if (!$tenant) {
            return;
        }

        // Sales Pipeline
        $salesPipeline = Pipeline::firstOrCreate(
            ['tenant_id' => $tenant->id, 'name' => 'Sales Pipeline'],
            [
                'tenant_id' => $tenant->id,
                'type' => 'sales',
                'is_default' => true,
                'is_active' => true,
            ]
        );

        $salesStages = [
            ['name' => 'New Lead', 'probability' => 10, 'color' => '#3B82F6', 'position' => 1],
            ['name' => 'Contacted', 'probability' => 20, 'color' => '#8B5CF6', 'position' => 2],
            ['name' => 'Qualified', 'probability' => 40, 'color' => '#F59E0B', 'position' => 3],
            ['name' => 'Proposal Sent', 'probability' => 60, 'color' => '#10B981', 'position' => 4],
            ['name' => 'Negotiation', 'probability' => 80, 'color' => '#06B6D4', 'position' => 5],
            ['name' => 'Closed Won', 'probability' => 100, 'color' => '#22C55E', 'position' => 6, 'is_won' => true],
            ['name' => 'Closed Lost', 'probability' => 0, 'color' => '#EF4444', 'position' => 7, 'is_lost' => true],
        ];

        foreach ($salesStages as $index => $stage) {
            PipelineStage::firstOrCreate(
                ['pipeline_id' => $salesPipeline->id, 'name' => $stage['name']],
                array_merge($stage, [
                    'tenant_id' => $tenant->id,
                    'pipeline_id' => $salesPipeline->id,
                    'is_default' => $index === 0,
                ])
            );
        }

        // Company Formation Pipeline
        $formationPipeline = Pipeline::firstOrCreate(
            ['tenant_id' => $tenant->id, 'name' => 'Company Formation'],
            [
                'tenant_id' => $tenant->id,
                'type' => 'sales',
                'is_default' => false,
                'is_active' => true,
            ]
        );

        $formationStages = [
            ['name' => 'Inquiry', 'probability' => 10, 'color' => '#3B82F6', 'position' => 1],
            ['name' => 'Consultation', 'probability' => 25, 'color' => '#8B5CF6', 'position' => 2],
            ['name' => 'Documents Collected', 'probability' => 40, 'color' => '#F59E0B', 'position' => 3],
            ['name' => 'MOICT Submission', 'probability' => 60, 'color' => '#10B981', 'position' => 4],
            ['name' => 'CR Issued', 'probability' => 75, 'color' => '#06B6D4', 'position' => 5],
            ['name' => 'Bank Account Opening', 'probability' => 90, 'color' => '#EC4899', 'position' => 6],
            ['name' => 'Completed', 'probability' => 100, 'color' => '#22C55E', 'position' => 7, 'is_won' => true],
            ['name' => 'Cancelled', 'probability' => 0, 'color' => '#EF4444', 'position' => 8, 'is_lost' => true],
        ];

        foreach ($formationStages as $index => $stage) {
            PipelineStage::firstOrCreate(
                ['pipeline_id' => $formationPipeline->id, 'name' => $stage['name']],
                array_merge($stage, [
                    'tenant_id' => $tenant->id,
                    'pipeline_id' => $formationPipeline->id,
                    'is_default' => $index === 0,
                ])
            );
        }
    }
}
