<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleAndPermissionSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            // Contacts
            'contacts.view', 'contacts.create', 'contacts.update', 'contacts.delete', 'contacts.export',
            // Invoices
            'invoices.view', 'invoices.create', 'invoices.update', 'invoices.delete', 'invoices.send',
            // Bills
            'bills.view', 'bills.create', 'bills.update', 'bills.delete', 'bills.pay',
            // Projects
            'projects.view', 'projects.create', 'projects.update', 'projects.delete', 'projects.manage_members',
            // Tasks
            'tasks.view', 'tasks.create', 'tasks.update', 'tasks.delete', 'tasks.assign',
            // Employees
            'employees.view', 'employees.create', 'employees.update', 'employees.delete', 'employees.view_payroll',
            // Payroll
            'payroll.view', 'payroll.process', 'payroll.approve',
            // Leave
            'leave.view', 'leave.request', 'leave.approve',
            // Reports
            'reports.financial', 'reports.hr', 'reports.crm', 'reports.projects',
            // Settings
            'settings.view', 'settings.update', 'settings.users', 'settings.billing',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Admin role
        $admin = Role::firstOrCreate(['name' => 'admin', 'display_name' => 'Administrator']);
        $admin->permissions()->sync(Permission::all());

        // Manager role
        $manager = Role::firstOrCreate(['name' => 'manager', 'display_name' => 'Manager']);
        $manager->permissions()->sync(Permission::whereNotIn('name', [
            'settings.users', 'settings.billing', 'employees.delete', 'payroll.process'
        ])->get());

        // Employee role
        $employee = Role::firstOrCreate(['name' => 'employee', 'display_name' => 'Employee']);
        $employee->permissions()->sync(Permission::whereIn('name', [
            'contacts.view', 'contacts.create', 'contacts.update',
            'invoices.view', 'invoices.create',
            'projects.view', 'tasks.view', 'tasks.create', 'tasks.update',
            'leave.view', 'leave.request',
        ])->get());

        // HR Manager
        $hr = Role::firstOrCreate(['name' => 'hr_manager', 'display_name' => 'HR Manager']);
        $hr->permissions()->sync(Permission::whereIn('name', [
            'employees.view', 'employees.create', 'employees.update', 'employees.view_payroll',
            'payroll.view', 'payroll.process',
            'leave.view', 'leave.approve',
            'reports.hr',
        ])->get());

        // Accountant
        $accountant = Role::firstOrCreate(['name' => 'accountant', 'display_name' => 'Accountant']);
        $accountant->permissions()->sync(Permission::whereIn('name', [
            'invoices.view', 'invoices.create', 'invoices.update', 'invoices.send',
            'bills.view', 'bills.create', 'bills.update', 'bills.pay',
            'reports.financial',
        ])->get());
    }
}
