<?php

namespace Database\Seeders;

use App\Models\TaxRate;
use Illuminate\Database\Seeder;

class TaxRateSeeder extends Seeder
{
    public function run(): void
    {
        $taxRates = [
            ['name' => 'VAT 10%', 'rate' => 10, 'type' => 'both', 'is_default' => true, 'description' => 'Bahrain VAT'],
            ['name' => 'VAT 5%', 'rate' => 5, 'type' => 'both', 'is_default' => false, 'description' => 'Reduced VAT'],
            ['name' => 'Zero Rated', 'rate' => 0, 'type' => 'both', 'is_default' => false, 'description' => 'Zero rated supplies'],
            ['name' => 'Exempt', 'rate' => 0, 'type' => 'both', 'is_default' => false, 'description' => 'VAT exempt supplies'],
        ];

        foreach ($taxRates as $taxRate) {
            TaxRate::updateOrCreate(
                ['name' => $taxRate['name'], 'tenant_id' => null],
                array_merge($taxRate, [
                    'is_active' => true,
                    'is_compound' => false,
                    'is_inclusive' => false,
                ])
            );
        }
    }
}
