<?php

namespace Database\Seeders;

use App\Models\Tenant;
use Illuminate\Database\Seeder;

class TenantSeeder extends Seeder
{
    public function run(): void
    {
        Tenant::firstOrCreate(
            ['slug' => 'setup-in-bahrain'],
            [
                'name' => 'Setup in Bahrain',
                'email' => 'info@setupinbahrain.com',
                'phone' => '+973 1234 5678',
                'website' => 'https://setupinbahrain.com',
                'address' => [
                    'line1' => 'Diplomatic Area',
                    'city' => 'Manama',
                    'country' => 'BH',
                ],
                'currency' => 'BHD',
                'timezone' => 'Asia/Bahrain',
                'date_format' => 'd/m/Y',
                'fiscal_year_start' => 1,
                'status' => 'active',
                'settings' => [
                    'invoice_prefix' => 'INV',
                    'invoice_next_number' => 1001,
                    'default_payment_terms' => 30,
                    'vat_rate' => 10,
                ],
            ]
        );
    }
}
