# 🚀 PARALLEL BUILD PLAN - 10 BOTS

## Project: Business Platform (GHL + QuickBooks + Asana Clone)
## Strategy: 10 Independent Workstreams

---

## 📋 BOT ASSIGNMENTS

| Bot | Module | Files to Create | Est. Lines |
|-----|--------|-----------------|------------|
| Bot 1 | Core/Auth/Tenants | ~45 files | ~8,000 |
| Bot 2 | CRM Module | ~50 files | ~12,000 |
| Bot 3 | Accounting - Invoicing | ~45 files | ~10,000 |
| Bot 4 | Accounting - Bills/Banking | ~40 files | ~9,000 |
| Bot 5 | Task Management | ~55 files | ~14,000 |
| Bot 6 | HR/Payroll | ~45 files | ~10,000 |
| Bot 7 | Communication | ~50 files | ~12,000 |
| Bot 8 | Marketing/Automation | ~45 files | ~10,000 |
| Bot 9 | Frontend - Core/CRM | ~60 files | ~18,000 |
| Bot 10 | Frontend - Accounting/Tasks | ~60 files | ~18,000 |

**TOTAL: ~495 files, ~121,000 lines**

---

## 🔧 SHARED CONVENTIONS (ALL BOTS MUST FOLLOW)

### File Structure
```
/home/claude/business-platform/
├── app/
│   ├── Models/
│   ├── Http/Controllers/Api/
│   ├── Http/Requests/
│   ├── Services/
│   ├── Jobs/
│   ├── Events/
│   ├── Listeners/
│   ├── Notifications/
│   ├── Policies/
│   └── Traits/
├── database/
│   ├── migrations/
│   └── seeders/
├── routes/
├── resources/
│   ├── js/
│   │   ├── Components/
│   │   ├── Pages/
│   │   └── Layouts/
│   └── views/
└── tests/
```

### Naming Conventions
- Models: PascalCase singular (Contact, Invoice)
- Controllers: PascalCase + Controller (ContactController)
- Services: PascalCase + Service (InvoiceService)
- Requests: PascalCase + Request (StoreContactRequest)
- Tables: snake_case plural (contacts, invoices)
- Routes: kebab-case (api/contacts, api/invoices)

### Base Classes to Extend
- Models extend: `App\Models\BaseModel`
- Controllers extend: `App\Http\Controllers\Api\ApiController`
- Use trait: `App\Traits\BelongsToTenant` for tenant-scoped models

### Response Format
```php
// Success
return $this->success($data, 'Message', 200);

// Error
return $this->error('Message', 400, $errors);

// Paginated
return $this->paginated($paginator);
```

---

## 📁 TASK FILES LOCATION

Each bot should read their specific task file:
- `/home/claude/business-platform/docs/BOT_1_TASKS.md`
- `/home/claude/business-platform/docs/BOT_2_TASKS.md`
- ... etc

---

## ⚠️ DEPENDENCY ORDER

Some bots have dependencies. Follow this order:

```
PHASE 1 (Start immediately - no dependencies):
├── Bot 1: Core/Auth ──────────┐
├── Bot 6: HR/Payroll          │
└── Bot 7: Communication       │
                               │
PHASE 2 (After Bot 1 completes):
├── Bot 2: CRM ────────────────┤
├── Bot 3: Accounting-Invoices │
├── Bot 4: Accounting-Bills    │
├── Bot 5: Task Management     │
└── Bot 8: Marketing           │
                               │
PHASE 3 (After Backend complete):
├── Bot 9: Frontend Core/CRM ──┤
└── Bot 10: Frontend Acct/Tasks┘
```

**However, all bots CAN start simultaneously** - just use placeholder imports for dependencies.

---

## 🎯 EACH BOT MUST CREATE:

1. **Migrations** - Any remaining for their module
2. **Models** - With relationships, scopes, accessors
3. **Controllers** - Full CRUD + custom actions
4. **Services** - Business logic layer
5. **Form Requests** - Validation rules
6. **Policies** - Authorization rules
7. **Routes** - API route definitions
8. **Jobs** - Background processing
9. **Events/Listeners** - Event handling
10. **Notifications** - Email/SMS/Push
11. **Seeders** - Test data
12. **Tests** - Feature tests

---

## 📊 PROGRESS TRACKING

Each bot updates their progress in:
`/home/claude/business-platform/docs/PROGRESS_BOT_X.md`

Format:
```markdown
# Bot X Progress

## Completed
- [x] File 1
- [x] File 2

## In Progress
- [ ] File 3

## Remaining
- [ ] File 4

## Issues/Blockers
- None
```
