const routes = [
    { path: '/login', name: 'login', component: () => import('./pages/auth/Login.vue') },
    { path: '/register', name: 'register', component: () => import('./pages/auth/Register.vue') },
    { path: '/forgot-password', name: 'forgot-password', component: () => import('./pages/auth/ForgotPassword.vue') },
    
    {
        path: '/',
        component: () => import('./layouts/AppLayout.vue'),
        meta: { requiresAuth: true },
        children: [
            { path: '', redirect: '/dashboard' },
            { path: 'dashboard', name: 'dashboard', component: () => import('./pages/Dashboard.vue') },
            
            // CRM
            { path: 'contacts', name: 'contacts', component: () => import('./pages/crm/ContactList.vue') },
            { path: 'contacts/create', name: 'contacts.create', component: () => import('./pages/crm/ContactForm.vue') },
            { path: 'contacts/:id', name: 'contacts.show', component: () => import('./pages/crm/ContactDetail.vue') },
            { path: 'contacts/:id/edit', name: 'contacts.edit', component: () => import('./pages/crm/ContactForm.vue') },
            
            { path: 'pipelines', name: 'pipelines', component: () => import('./pages/crm/PipelineBoard.vue') },
            { path: 'opportunities', name: 'opportunities', component: () => import('./pages/crm/OpportunityList.vue') },
            
            // Accounting
            { path: 'invoices', name: 'invoices', component: () => import('./pages/accounting/InvoiceList.vue') },
            { path: 'invoices/create', name: 'invoices.create', component: () => import('./pages/accounting/InvoiceForm.vue') },
            { path: 'invoices/:id', name: 'invoices.show', component: () => import('./pages/accounting/InvoiceDetail.vue') },
            { path: 'invoices/:id/edit', name: 'invoices.edit', component: () => import('./pages/accounting/InvoiceForm.vue') },
            
            { path: 'estimates', name: 'estimates', component: () => import('./pages/accounting/EstimateList.vue') },
            { path: 'bills', name: 'bills', component: () => import('./pages/accounting/BillList.vue') },
            { path: 'expenses', name: 'expenses', component: () => import('./pages/accounting/ExpenseList.vue') },
            { path: 'banking', name: 'banking', component: () => import('./pages/accounting/BankAccounts.vue') },
            { path: 'banking/transactions', name: 'banking.transactions', component: () => import('./pages/accounting/BankTransactions.vue') },
            
            // Task Management
            { path: 'projects', name: 'projects', component: () => import('./pages/tasks/ProjectList.vue') },
            { path: 'projects/:id', name: 'projects.show', component: () => import('./pages/tasks/ProjectBoard.vue') },
            { path: 'tasks', name: 'tasks', component: () => import('./pages/tasks/TaskList.vue') },
            { path: 'time', name: 'time', component: () => import('./pages/tasks/TimeTracking.vue') },
            
            // HR
            { path: 'employees', name: 'employees', component: () => import('./pages/hr/EmployeeList.vue') },
            { path: 'employees/:id', name: 'employees.show', component: () => import('./pages/hr/EmployeeDetail.vue') },
            { path: 'leave', name: 'leave', component: () => import('./pages/hr/LeaveRequests.vue') },
            { path: 'payroll', name: 'payroll', component: () => import('./pages/hr/PayrollRuns.vue') },
            
            // Communication
            { path: 'campaigns', name: 'campaigns', component: () => import('./pages/communication/CampaignList.vue') },
            { path: 'forms', name: 'forms', component: () => import('./pages/communication/FormList.vue') },
            { path: 'workflows', name: 'workflows', component: () => import('./pages/communication/WorkflowList.vue') },
            
            // Reports
            { path: 'reports', name: 'reports', component: () => import('./pages/reports/ReportDashboard.vue') },
            { path: 'reports/profit-loss', name: 'reports.profit-loss', component: () => import('./pages/reports/ProfitLoss.vue') },
            { path: 'reports/balance-sheet', name: 'reports.balance-sheet', component: () => import('./pages/reports/BalanceSheet.vue') },
            
            // Settings
            { path: 'settings', name: 'settings', component: () => import('./pages/settings/Settings.vue') },
            { path: 'settings/users', name: 'settings.users', component: () => import('./pages/settings/Users.vue') },
        ],
    },
];

export default routes;
