import { defineStore } from 'pinia';
import api from '../api';

export const useAuthStore = defineStore('auth', {
    state: () => ({
        user: null,
        token: localStorage.getItem('token'),
        tenant: null,
    }),

    getters: {
        isAuthenticated: (state) => !!state.token,
        currentUser: (state) => state.user,
    },

    actions: {
        async login(credentials) {
            const { data } = await api.post('/auth/login', credentials);
            this.token = data.token;
            this.user = data.user;
            this.tenant = data.tenant;
            localStorage.setItem('token', data.token);
        },

        async logout() {
            await api.post('/auth/logout');
            this.token = null;
            this.user = null;
            this.tenant = null;
            localStorage.removeItem('token');
        },

        async fetchUser() {
            if (!this.token) return;
            const { data } = await api.get('/auth/me');
            this.user = data.user;
            this.tenant = data.tenant;
        },

        async updateProfile(profileData) {
            const { data } = await api.put('/auth/profile', profileData);
            this.user = data.user;
        },
    },
});
