import { defineStore } from 'pinia';
import api from '../api';

export const useContactStore = defineStore('contacts', {
    state: () => ({
        contacts: [],
        contact: null,
        pagination: null,
        loading: false,
        filters: {
            search: '',
            status: '',
            tags: [],
        },
    }),

    actions: {
        async fetchContacts(params = {}) {
            this.loading = true;
            try {
                const { data } = await api.get('/contacts', { params: { ...this.filters, ...params } });
                this.contacts = data.data;
                this.pagination = data.meta;
            } finally {
                this.loading = false;
            }
        },

        async fetchContact(id) {
            this.loading = true;
            try {
                const { data } = await api.get(`/contacts/${id}`);
                this.contact = data.data;
            } finally {
                this.loading = false;
            }
        },

        async createContact(contactData) {
            const { data } = await api.post('/contacts', contactData);
            this.contacts.unshift(data.data);
            return data.data;
        },

        async updateContact(id, contactData) {
            const { data } = await api.put(`/contacts/${id}`, contactData);
            const index = this.contacts.findIndex(c => c.id === id);
            if (index !== -1) this.contacts[index] = data.data;
            return data.data;
        },

        async deleteContact(id) {
            await api.delete(`/contacts/${id}`);
            this.contacts = this.contacts.filter(c => c.id !== id);
        },

        setFilters(filters) {
            this.filters = { ...this.filters, ...filters };
        },
    },
});
